<?php
/**
* 
* { Description :- 
*	Divides the ResultSet returned  by the database in to pages.
* }
*/

class Pagination
{
	var $result;
	var $pageSize;
	var $page;
	var $numRows;
	var $row=0;
	var $showPageNumbers;
	var $resultPage;
	var $conn;
	
	/**
	* Method Pagination::getNumPages()
	*
	* { Description :- 
	*	returns the total number of pages required.
	* }
	*/
	
	function getNumPages()
	{
		if(is_resource($this->result))
		{
			return ceil(($this->numRows)/(float)($this->pageSize));
		}
		else
		{
			return false;
		}
	}
	
	/**
	* Method Pagination::getNumPages()
	*
	* { Description :- 
	*	returns the page number
	* }
	*/
	
	function getPageNum()
	{
		return $this->page;
	}
	
	/**
	* Method Pagination::getPageNav()
	*
	* { Description :- 
	*	returns the page navigation links.
	* }
	*/
	
	function getPageNav()
	{	
		$nav="";
		if(!($this->page <= 1))
		{
			$nextpage = $this->getPageNum();
			$nextpage--;
			$nav .= "<a href=\"?resultPage=$nextpage\"><font color=\"blue\" size=\"2pt\"><b>Prev</b></font></a>\n";
		}
		else
		{
			$nav .= "<font size=\"2pt\"><b>Prev</b></font>\n";
		}
		
		if($this->getNumPages() >= 1)
		{
			for($i=1; $i<=$this->getNumPages();$i++)
			{
				if($i == $this->getPageNum())
				{
					$nav .= "<font size=\"2pt\"><b>&nbsp;$i<b></font>&nbsp;\n";
				}
				else
				{
					$nav .= "<a href=\"?resultPage=$i\"><font color=\"blue\" size=\"2pt\"><b>&nbsp;$i</b></font></a>&nbsp;\n";
				}
			}
		}
		if(!($this->page >= $this->getNumPages()))
		{
			$nextpage = $this->getPageNum();
			$nextpage++;
			$nav .= "<a href=\"?resultPage=$nextpage\"><font color=\"blue\" size=\"2pt\"><b>Next</b></font></a>\n";
		}
		else
		{
			$nav .= "<font size=\"2pt\"><b>Next</b></font>\n";
		}
		return $nav;
	}
}

/**
* class MySqlPagination
*
* { Description :- 
*	Divides the ResultSet returned  by the MySQL database in to pages.This class extends Pagination class.
* }
*/

class MySqlPagination extends Pagination 
{
	/**
	* Method MySqlPagination::MySqlPagination()
	*
	* { Description :- 
	*	Constructor
	* }
	*/
	
	function MySqlPagination($result, $pageSize, $conn, $numRows, $resultPage)
	{
		$this->resultPage = $resultPage;
		
		$this->result = $result;
		$this->pageSize = $pageSize;
		
		$this->numRows = $numRows;
		//$this->showPageNumbers = $showPageNumbers;
		$this->conn = $conn;
		
		if(($this->resultPage <= 0) || (empty($this->resultPage)))
			$this->resultPage = 1;
		
		if($this->page > $this->getNumPages())
			$this->resultPage = $this->getNumPages();
		$this->setPageNum();
		
	}
	
	/**
	* Method MySqlPagination::setPageNum()
	*
	* { Description :- 
	*	sets the paqe number depending on the pagesize.
	* }
	*/
	
	function setPageNum()
	{
		if($this->resultPage > $this->getNumPages() || $this->resultPage <= 0)
		{
			return false;
		}
		$this->page = $this->resultPage;
		$this->row = 0;
		mysql_data_seek($this->result, ($this->page-1)*$this->pageSize);
	}
	
	/**
	* Method MySqlPagination::getPageData()
	*
	* { Description :- 
	*	returns the data associated with the page.
	* }
	*/
	
	function getPageData()
	{
		if(!is_resource($this->result))
		{
			return false;			
		}
		elseif($this->row >= $this->pageSize)
		{
			return false;
		}
		elseif($this->numRows == 0)
		{
			return  false;
		}
		$this->row++;
		return mysql_fetch_array(($this->result), MYSQL_ASSOC);
	}
}

/**
* class MSSqlPagination
*
* { Description :- 
*	Divides the ResultSet returned  by the MS SQL SERVER database in to pages.This class extends Pagination class.
* }
*/

class MSSqlPagination extends Pagination 
{
	/**
	* Method MSSqlPagination::MSSqlPagination()
	*
	* { Description :- 
	*	Constructor
	* }
	*/
	
	function MSSqlPagination($result, $pageSize, $conn, $numRows, $resultPage)
	{
		$this->resultPage = $resultPage;
		
		$this->result = $result;
		$this->pageSize = $pageSize;
		
		$this->numRows = $numRows;
		//$this->showPageNumbers = $showPageNumbers;
		$this->conn = $conn;
		
		if(($this->resultPage <= 0) || (empty($this->resultPage)))
			$this->resultPage = 1;
		
		if($this->page > $this->getNumPages())
			$this->resultPage = $this->getNumPages();
		$this->setPageNum();
		
	}
	
	/**
	* Method MSSqlPagination::setPageNum()
	*
	* { Description :- 
	*	sets the paqe number depending on the pagesize.
	* }
	*/
	
	function setPageNum()
	{
		if($this->resultPage > $this->getNumPages() || $this->resultPage <= 0)
		{
			return false;
		}
		$this->page = $this->resultPage;
		$this->row = 0;
		mssql_data_seek($this->result, ($this->page-1)*$this->pageSize);
	}
	
	/**
	* Method MSSqlPagination::getPageData()
	*
	* { Description :- 
	*	returns the data associated with the page.
	* }
	*/
	
	function getPageData()
	{
		if(!is_resource($this->result))
		{
			return false;			
		}
		elseif($this->row >= $this->pageSize)
		{
			return false;
		}
		elseif($this->numRows == 0)
		{
			return  false;
		}
		$this->row++;
		return mssql_fetch_array(($this->result), $this->conn);
	}
}


?>