<?php 
function watermark($SourceFile, $WatermarkFile, $SaveToFile = NULL) 
{ 
    $watermark = @imagecreatefrompng($WatermarkFile) 
    or exit('Cannot open the watermark file.'); 
    imageAlphaBlending($watermark, false); 
    imageSaveAlpha($watermark, true); 
    $image_string = @file_get_contents($SourceFile) 
    or exit('Cannot open image file.'); 
    $image = @imagecreatefromstring($image_string) 
    or exit('Not a valid image format.'); 
    $imageWidth=imageSX($image); 
    $imageHeight=imageSY($image); 
    $watermarkWidth=imageSX($watermark); 
    $watermarkHeight=imageSY($watermark); 
    $coordinate_X = ( $imageWidth - 5) - ( $watermarkWidth); 
    $coordinate_Y = ( $imageHeight - 5) - ( $watermarkHeight); 
	$coordinate_X = ( $imageWidth /2) - ( $watermarkWidth); 
    $coordinate_Y = ( $imageHeight /2) - ( $watermarkHeight); 
    imagecopy($image, $watermark, $coordinate_X, $coordinate_Y, 
        0, 0, $watermarkWidth, $watermarkHeight); 
    if(!($SaveToFile)) header('Content-Type: image/jpeg'); 
    imagejpeg ($image, $SaveToFile, 100); 
    imagedestroy($image); 
    imagedestroy($watermark); 
    if(!($SaveToFile)) exit; 
} 
?>